import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table"
import { Button } from "@/components/ui/button"

export function WithdrawalRequestsTable({ requests, onApprove }) {
  if (!requests || requests.length === 0) {
    return <p>No withdrawal requests to display.</p>
  }

  return (
    <Table>
      <TableHeader>
        <TableRow>
          <TableHead>ID</TableHead>
          <TableHead>Type</TableHead>
          <TableHead>Requester</TableHead>
          <TableHead>Amount</TableHead>
          <TableHead>Status</TableHead>
          <TableHead>Date</TableHead>
          <TableHead>Actions</TableHead>
        </TableRow>
      </TableHeader>
      <TableBody>
        {requests.map((request) => (
          <TableRow key={request.withdrawal_id}>
            <TableCell className="font-medium">{request.withdrawal_id}</TableCell>
            <TableCell>{request.withdrawal_type}</TableCell>
            <TableCell>{request.requester_name}</TableCell>
            <TableCell>₦{parseFloat(request.amount).toLocaleString()}</TableCell>
            <TableCell>{request.status}</TableCell>
            <TableCell>{new Date(request.requested_at).toLocaleDateString()}</TableCell>
            <TableCell>
              {request.status === "pending" && (
                <Button
                  size="sm"
                  onClick={() => onApprove(request.withdrawal_id, request.withdrawal_type)}
                >
                  Approve
                </Button>
              )}
            </TableCell>
          </TableRow>
        ))}
      </TableBody>
    </Table>
  )
}