import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table"

export function CommissionsList({ commissions, userRole }) {
  if (!commissions || commissions.length === 0) {
    return <p>No commissions to display.</p>
  }

  return (
    <Table>
      <TableHeader>
        <TableRow>
          <TableHead>Commission ID</TableHead>
          {userRole === "super-agent" ? (
            <TableHead>Agent Name</TableHead>
          ) : (
            <TableHead>Customer Name</TableHead>
          )}
          <TableHead>Amount</TableHead>
          <TableHead>Payment Method</TableHead>
          <TableHead>Date</TableHead>
        </TableRow>
      </TableHeader>
      <TableBody>
        {commissions.map((commission) => (
          <TableRow key={commission.commission_id}>
            <TableCell className="font-medium">{commission.commission_id}</TableCell>
            <TableCell>
              {userRole === "super-agent"
                ? commission.agent_name
                : commission.customer_name}
            </TableCell>
            <TableCell>₦{parseFloat(commission.commission_amount).toLocaleString()}</TableCell>
            <TableCell>{commission.payment_method}</TableCell>
            <TableCell>{new Date(commission.commission_date).toLocaleDateString()}</TableCell>
          </TableRow>
        ))}
      </TableBody>
    </Table>
  )
}