"use client"
import Link from "next/link"
import { usePathname } from "next/navigation"
import {
  Users,
  Smartphone,
  CreditCard,
  BarChart3,
  Settings,
  Home,
  Package,
  DollarSign,
  UserCheck,
  Zap,
  TrendingUp,
  Tag,
} from "lucide-react"
import log from "../public/logo.png"

import {
  Sidebar,
  SidebarContent,
  SidebarFooter,
  SidebarGroup,
  SidebarGroupContent,
  SidebarGroupLabel,
  SidebarHeader,
  SidebarMenu,
  SidebarMenuButton,
  SidebarMenuItem,
  SidebarRail,
} from "@/components/ui/sidebar"

const navigationItems = [
  {
    title: "Overview",
    items: [
      {
        title: "Dashboard",
        url: "/dashboard",
        icon: Home,
      },
      // {
      //   title: "Analytics",
      //   url: "/analytics",
      //   icon: BarChart3,
      // },
    ],
  },
  {
    title: "Management",
    items: [
      {
        title: "Agents",
        url: "/agents",
        icon: UserCheck,
      },
      // {
      //   title: "Super Agents",
      //   url: "/super-agents",
      //   icon: Users,
      // },
      {
        title: "Devices",
        url: "/devices",
        icon: Smartphone,
      },
      {
        title: "Customers",
        url: "/customers",
        icon: Users,
      },
      {
        title: "Loans",
        url: "/loans",
        icon: CreditCard,
      },
      {
        title: "Deals",
        url: "/deals",
        icon: Tag,
      },
    ],
  },
  {
    title: "Operations",
    items: [
      {
        title: "Payments",
        url: "/payments",
        icon: DollarSign,
      },
      {
        title: "Inventory",
        url: "/inventory",
        icon: Package,
      },
      // {
      //   title: "Energy Usage",
      //   url: "/energy",
      //   icon: Zap,
      // },
    ],
  },
  {
    title: "System",
    items: [
      {
        title: "Reports",
        url: "/reports",
        icon: TrendingUp,
      },
      {
        title: "Settings",
        url: "/admin/settings",
        icon: Settings,
      },
    ],
  },
]

import { LogOut } from "lucide-react";
import { useRouter } from "next/navigation";

// ... (imports)

export function AppSidebar({ ...props }) {
  const pathname = usePathname();
  const router = useRouter();

  const handleLogout = () => {
    localStorage.removeItem("token");
    router.push("/login");
  };

  return (
    <Sidebar {...props}>
      <SidebarHeader>
        <div className="flex items-center gap-2 px-4 py-2">
          <div className="h-6 w-6" >
            <img src="/logo.png" alt="logo" />
          </div>
          <span className="font-bold text-lg">RayConnect</span>
        </div>
      </SidebarHeader>
      <SidebarContent>
        {navigationItems.map((section) => (
          <SidebarGroup key={section.title}>
            <SidebarGroupLabel>{section.title}</SidebarGroupLabel>
            <SidebarGroupContent>
              <SidebarMenu>
                {section.items.map((item) => (
                  <SidebarMenuItem key={item.title}>
                    <SidebarMenuButton asChild isActive={pathname === item.url}>
                      <Link href={item.url}>
                        <item.icon />
                        <span>{item.title}</span>
                      </Link>
                    </SidebarMenuButton>
                  </SidebarMenuItem>
                ))}
              </SidebarMenu>
            </SidebarGroupContent>
          </SidebarGroup>
        ))}
      </SidebarContent>
      <SidebarFooter>
        <SidebarMenu>
          <SidebarMenuItem>
            <SidebarMenuButton onClick={handleLogout}>
              <LogOut />
              <span>Logout</span>
            </SidebarMenuButton>
          </SidebarMenuItem>
        </SidebarMenu>
      </SidebarFooter>
      <SidebarRail />
    </Sidebar>
  );
}